import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { queryResponse } from "../util/processResponse.js";

const initialState = {
    allStatus: {},
    loading: false,
};

export const getAllOrderStatus = createAsyncThunk(
    "orders/getAllOrderStatus",
    async ({ URL }) => {
        const response = await queryResponse(URL, "GET");
        return response;
    }
);

const getAllOrderStatusSlice = createSlice({
    name: "allOrderStatus",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(getAllOrderStatus.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getAllOrderStatus.fulfilled, (state, { payload }) => {
            state.loading = false;
            state.allStatus = payload;
        });
        builder.addCase(getAllOrderStatus.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default getAllOrderStatusSlice.reducer;
